package ru.yandex.travel.orders.services.migrations.attachments;

import java.util.Collection;
import java.util.UUID;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.context.annotation.Import;
import org.springframework.http.MediaType;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import ru.yandex.travel.orders.entities.notifications.Attachment;
import ru.yandex.travel.orders.entities.notifications.AttachmentProviderType;
import ru.yandex.travel.orders.repository.migrations.AttachmentDataToS3MigrationRepository;
import ru.yandex.travel.orders.services.cloud.s3.S3Service;
import ru.yandex.travel.orders.test.CommonIntegrationTestConfiguration;
import ru.yandex.travel.orders.test.TestsTxHelper;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.ArgumentMatchers.argThat;
import static org.mockito.Mockito.verify;
import static ru.yandex.travel.orders.repository.migrations.AttachmentDataToS3MigrationRepositoryTest.attachment;

// the class isn't used anymore but we will temporarily keep at as a reference for other new tests
@RunWith(SpringRunner.class)
@DataJpaTest
@ActiveProfiles("test")
@Import({CommonIntegrationTestConfiguration.class})
@Ignore
public class AttachmentDataToS3MigrationProcessorTest {
    @Autowired
    private AttachmentDataToS3MigrationRepository repository;
    @Autowired
    private TestsTxHelper txHelper;
    @MockBean
    private S3Service s3Service;

    private AttachmentDataToS3MigrationProcessor processor;

    @Before
    public void init() {
        processor = new AttachmentDataToS3MigrationProcessor(repository, s3Service);
        //when(s3Service.isEnabled()).thenReturn(true);
    }

    @Test
    public void process() {
        // setup
        UUID attachmentId = txHelper.callInTx(() -> {
            Attachment attachment = attachment("attachment data");
            attachment.setMimeType(MediaType.TEXT_PLAIN_VALUE);
            attachment.setFilename("receipt1.txt");
            attachment.setProvider(AttachmentProviderType.FISCAL_RECEIPT);
            repository.save(attachment);
            return attachment.getId();
        });

        // processing
        txHelper.runInTx(() -> {
            Attachment attachment = repository.getOne(attachmentId);
            //assertThat(attachment.getData()).isNotNull();
            Collection<UUID> taskKeys = processor.getPendingTaskKeys(2);
            assertThat(taskKeys).hasSize(1);
            processor.process(taskKeys.iterator().next());
        });

        // validation
        txHelper.runInTx(() -> {
            Attachment attachment = repository.getOne(attachmentId);
            //assertThat(attachment.getData()).isNull();
            assertThat(attachment.getDataS3Id()).isNotNull().startsWith("attachments/fiscal_receipts/receipt1.txt.");
            verify(s3Service).uploadObject(argThat(obj -> new String(obj.getData()).equals("attachment data") &&
                    obj.getMimeType().equals(MediaType.TEXT_PLAIN_VALUE) &&
                    obj.getFileName().equals("receipt1.txt") &&
                    obj.getId().startsWith("attachments/fiscal_receipts/receipt1.txt.")
            ));
        });
    }
}
