package ru.yandex.travel.orders;

import lombok.RequiredArgsConstructor;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import ru.yandex.travel.orders.management.SupervisorService;
import ru.yandex.travel.orders.services.AccountService;

@Component
@RequiredArgsConstructor
public class ContextRefreshedListener implements ApplicationListener<ContextRefreshedEvent> {

    private final AccountService accountService;
    private final SupervisorService supervisorService;

    @Override
    @Transactional
    public void onApplicationEvent(ContextRefreshedEvent event) {
        accountService.createWellKnownAccs();
        supervisorService.ensureSupervisorsExist();
    }
}
