package ru.yandex.travel.orders;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Import;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

import ru.yandex.travel.hotels.services.promoservice.PromoServiceConfiguration;
import ru.yandex.travel.workflow.WorkflowConfiguration;
import ru.yandex.travel.workflow.repository.WorkflowRepositoryConfiguration;

@SpringBootApplication
@EnableJpaRepositories(
        basePackages = {"ru.yandex.travel.orders", "ru.yandex.travel.workflow"},
        enableDefaultTransactions = false
)
@EnableConfigurationProperties(OrdersApplicationProperties.class)
@Import({
        WorkflowConfiguration.class,
        // we need this configuration to be enabled everywhere, including all @DataJpaTest-s
        WorkflowRepositoryConfiguration.class,
})
@ImportAutoConfiguration(PromoServiceConfiguration.class)
@Slf4j
public class OrdersApplication {

    public static void main(String[] args) {
        SpringApplication.run(OrdersApplication.class, args);
    }
}
