package ru.yandex.travel.orders;

import java.time.Duration;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value = "orders", ignoreUnknownFields = false)
@Data
public class OrdersApplicationProperties {
    private String flywayTargetMigrationVersion;

    private Duration shutdownTimeout;

    private boolean apiCallsRequireMaster;

    private boolean trainOrdersMockPayment;

    private boolean requireAppCallIdForWrite;

    private boolean refreshOrderAggregateStateOnWrite;

    private boolean syncCheckout;
}
