package ru.yandex.travel.orders;

import java.math.BigInteger;

import ru.yandex.travel.commons.proto.Error;

public class PrettyIdHelper {
    private static final BigInteger BASE = BigInteger.valueOf(1000000000061L);
    private static final BigInteger MODULUS = BigInteger.valueOf(1000000000063L);
    private static final BigInteger WARNING_ID_TOO_BIG = MODULUS.divide(BigInteger.valueOf(10L)).multiply(BigInteger.valueOf(8L));

    private PrettyIdHelper() {
    }

    public static String makePrettyId(long id) {
        BigInteger prettyId = BASE.modPow(BigInteger.valueOf(id), MODULUS);
        return prettifyGeneratedId(prettyId);
    }

    private static String prettifyGeneratedId(BigInteger prettyIdInt) {
        String prettyId = prettyIdInt.toString();
        StringBuilder builder = new StringBuilder("YA-");
        int leadingZeroLength = prettyId.length() >= 12 ? 0 : (12 - prettyId.length());
        int fourCnt = 0;
        while (leadingZeroLength != 0) {
            builder.append("0");
            fourCnt++;
            if (fourCnt == 4) {
                builder.append("-");
                fourCnt = 0;
            }
            leadingZeroLength--;
        }
        for (int i = 0; i < prettyId.length(); i++) {
            builder.append(prettyId.charAt(i));
            fourCnt++;
            if (fourCnt == 4 && i != prettyId.length() - 1) {
                builder.append("-");
                fourCnt = 0;
            }
        }
        return builder.toString();
    }

    public static boolean checkIdSequenceValue(Long id) {
        Error.checkState(BigInteger.valueOf(id).compareTo(WARNING_ID_TOO_BIG) < 0,
                "PrettyId sequence used > 80% of its capacity");
        BigInteger prettyId = BASE.modPow(BigInteger.valueOf(id), MODULUS);
        return prettyId.compareTo(BigInteger.valueOf(1000000000000L)) < 0;
    }
}
