package ru.yandex.travel.orders.configurations;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;

import ru.yandex.avia.booking.services.tdapi.AviaTicketDaemonApiClient;
import ru.yandex.avia.booking.services.tdapi.AviaTicketDaemonApiProperties;
import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.tvm.TvmWrapper;

@Configuration
public class ApiClientsConfiguration {
    @Bean
    @ConfigurationProperties(value = "avia-td-api", ignoreUnknownFields = false)
    @Validated
    public AviaTicketDaemonApiProperties aviaTicketDaemonApiProperties() {
        return new AviaTicketDaemonApiProperties();
    }

    @Bean
    public AviaTicketDaemonApiClient aviaTicketDaemonApiClient(
            AsyncHttpClientWrapper aviaApiAhcClientWrapper,
            @Autowired(required = false) TvmWrapper tvm,
            AviaTicketDaemonApiProperties config
    ) {
        return new AviaTicketDaemonApiClient(aviaApiAhcClientWrapper, tvm, config);
    }
}
