package ru.yandex.travel.orders.configurations;

import java.time.Duration;
import java.util.List;

import javax.validation.constraints.NotEmpty;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Data
@NoArgsConstructor
@ConfigurationProperties(value = "balance-contracts.yt-cache", ignoreUnknownFields = false)
@Validated
public class BalanceContractDictionaryProperties {
    @NotEmpty
    private List<String> proxy;
    @NotEmpty
    private String token;
    @NotEmpty
    private String balanceContractsYtTable;
    @NotEmpty
    private String baseLocalPath;
    private Duration updateInterval;
}
