package ru.yandex.travel.orders.configurations;

import com.google.common.collect.ImmutableSet;
import io.grpc.health.v1.HealthGrpc;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import ru.yandex.travel.grpc.interceptors.LoggingServerInterceptorBlacklistMethodsSupplier;
import ru.yandex.travel.orders.proto.HADiscoveryInterfaceV1Grpc;

@Configuration
public class GrpcCustomConfiguration {
    @Bean
    @Primary
    public LoggingServerInterceptorBlacklistMethodsSupplier loggingServerInterceptorBlacklistMethodsSupplier() {
        return () -> ImmutableSet.of(
                HADiscoveryInterfaceV1Grpc.getPingMethod().getFullMethodName(),
                HealthGrpc.getCheckMethod().getFullMethodName()
        );
    }
}
