package ru.yandex.travel.orders.configurations;

import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.cache.HotelAgreementDictionary;
import ru.yandex.travel.orders.services.finances.HotelAgreementServiceProperties;

@Configuration
@RequiredArgsConstructor
public class HotelAgreementDictionaryConfiguration {

    private final HotelAgreementServiceProperties hotelAgreementServiceProperties;

    @Bean
    public HotelAgreementDictionary hotelAgreementDictionary() {
        return HotelAgreementDictionary.fromBaseProperties(hotelAgreementServiceProperties.getYtCache());
    }
}
