package ru.yandex.travel.orders.configurations;

import java.util.Map;
import java.util.Set;

import javax.persistence.EntityManager;

import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.travel.orders.entities.AeroflotInvoice;
import ru.yandex.travel.orders.entities.AeroflotMqMessage;
import ru.yandex.travel.orders.entities.AeroflotOrder;
import ru.yandex.travel.orders.entities.AeroflotOrderItem;
import ru.yandex.travel.orders.entities.BNovoOrderItem;
import ru.yandex.travel.orders.entities.BronevikOrderItem;
import ru.yandex.travel.orders.entities.BusOrderItem;
import ru.yandex.travel.orders.entities.BusTicketRefund;
import ru.yandex.travel.orders.entities.DolphinOrderItem;
import ru.yandex.travel.orders.entities.ExpediaOrderItem;
import ru.yandex.travel.orders.entities.GenericOrder;
import ru.yandex.travel.orders.entities.HotelOrder;
import ru.yandex.travel.orders.entities.PaymentSchedule;
import ru.yandex.travel.orders.entities.PendingInvoice;
import ru.yandex.travel.orders.entities.SimpleTrustRefund;
import ru.yandex.travel.orders.entities.SuburbanOrderItem;
import ru.yandex.travel.orders.entities.Ticket;
import ru.yandex.travel.orders.entities.TrainInsuranceRefund;
import ru.yandex.travel.orders.entities.TrainOrder;
import ru.yandex.travel.orders.entities.TrainOrderItem;
import ru.yandex.travel.orders.entities.TrainTicketRefund;
import ru.yandex.travel.orders.entities.TravellineOrderItem;
import ru.yandex.travel.orders.entities.TrustInvoice;
import ru.yandex.travel.orders.entities.Voucher;
import ru.yandex.travel.orders.entities.WellKnownWorkflowEntityType;
import ru.yandex.travel.orders.entities.YandexPlusTopup;
import ru.yandex.travel.orders.entities.notifications.Attachment;
import ru.yandex.travel.orders.entities.notifications.Notification;
import ru.yandex.travel.workflow.BasicMessagingContext;
import ru.yandex.travel.workflow.MessagingContextFactory;
import ru.yandex.travel.workflow.entities.CommonWorkflowTypes;
import ru.yandex.travel.workflow.entities.SingleOperation;

@Configuration
public class MessagingContextFactoryConfiguration {

    @Autowired
    private EntityManager entityManager;

    @Bean
    public MessagingContextFactory messagingContextFactory() {
        Map<String, Class<?>> workflowEntityClasses = ImmutableMap.<String, Class<?>>builder()
                // hotels
                .put(WellKnownWorkflowEntityType.HOTEL_ORDER.getDiscriminatorValue(), HotelOrder.class)
                .put(WellKnownWorkflowEntityType.EXPEDIA_ORDER_ITEM.getDiscriminatorValue(), ExpediaOrderItem.class)
                .put(WellKnownWorkflowEntityType.DOLPHIN_ORDER_ITEM.getDiscriminatorValue(), DolphinOrderItem.class)
                .put(WellKnownWorkflowEntityType.TRAVELLINE_ORDER_ITEM.getDiscriminatorValue(), TravellineOrderItem.class)
                .put(WellKnownWorkflowEntityType.BNOVO_ORDER_ITEM.getDiscriminatorValue(), BNovoOrderItem.class)
                .put(WellKnownWorkflowEntityType.BRONEVIK_ORDER_ITEM.getDiscriminatorValue(), BronevikOrderItem.class)
                .put(WellKnownWorkflowEntityType.VOUCHER.getDiscriminatorValue(), Voucher.class)
                // avia
                .put(WellKnownWorkflowEntityType.AEROFLOT_ORDER.getDiscriminatorValue(), AeroflotOrder.class)
                .put(WellKnownWorkflowEntityType.AEROFLOT_ORDER_ITEM.getDiscriminatorValue(), AeroflotOrderItem.class)
                .put(WellKnownWorkflowEntityType.AEROFLOT_INVOICE.getDiscriminatorValue(), AeroflotInvoice.class)
                .put(WellKnownWorkflowEntityType.AEROFLOT_MQ_MESSAGE.getDiscriminatorValue(), AeroflotMqMessage.class)
                // bus
                .put(WellKnownWorkflowEntityType.BUS_ORDER_ITEM.getDiscriminatorValue(), BusOrderItem.class)
                .put(WellKnownWorkflowEntityType.BUS_TICKET_REFUND.getDiscriminatorValue(), BusTicketRefund.class)
                // generic
                .put(WellKnownWorkflowEntityType.GENERIC_ORDER.getDiscriminatorValue(), GenericOrder.class)
                // train
                .put(WellKnownWorkflowEntityType.TRAIN_ORDER.getDiscriminatorValue(), TrainOrder.class)
                .put(WellKnownWorkflowEntityType.TRAIN_ORDER_ITEM.getDiscriminatorValue(), TrainOrderItem.class)
                .put(WellKnownWorkflowEntityType.TRAIN_INSURANCE_REFUND.getDiscriminatorValue(), TrainInsuranceRefund.class)
                .put(WellKnownWorkflowEntityType.TRAIN_TICKET_REFUND.getDiscriminatorValue(), TrainTicketRefund.class)
                // suburban
                .put(WellKnownWorkflowEntityType.SUBURBAN_ORDER_ITEM.getDiscriminatorValue(), SuburbanOrderItem.class)
                // tickets
                .put(WellKnownWorkflowEntityType.STARTREK_ISSUE.getDiscriminatorValue(), Ticket.class)
                // notifications
                .put(WellKnownWorkflowEntityType.NOTIFICATION.getDiscriminatorValue(), Notification.class)
                .put(WellKnownWorkflowEntityType.ATTACHMENT.getDiscriminatorValue(), Attachment.class)
                .put(CommonWorkflowTypes.SINGLE_OPERATION.getDiscriminatorValue(), SingleOperation.class)
                // payments
                .put(WellKnownWorkflowEntityType.TRUST_INVOICE.getDiscriminatorValue(), TrustInvoice.class)
                .put(WellKnownWorkflowEntityType.TRUST_REFUND.getDiscriminatorValue(), SimpleTrustRefund.class)
                .put(WellKnownWorkflowEntityType.PLUS_POINTS_TOPUP.getDiscriminatorValue(), YandexPlusTopup.class)
                .put(WellKnownWorkflowEntityType.PENDING_INVOICE.getDiscriminatorValue(), PendingInvoice.class)
                .put(WellKnownWorkflowEntityType.PAYMENT_SCHEDULE.getDiscriminatorValue(), PaymentSchedule.class)
                // <String, JpaRepository>
                .build();
        Set<String> withoutRepository = Set.of(
                WellKnownWorkflowEntityType.ORDER_SUPERVISOR.getDiscriminatorValue(),
                WellKnownWorkflowEntityType.GENERIC_ERROR_SUPERVISOR.getDiscriminatorValue()
        );
        return (workflow, attempt) -> {
            if (withoutRepository.contains(workflow.getEntityType())) {
                return Option.of(new BasicMessagingContext<>(workflow.getId(), null, attempt, workflow.getWorkflowVersion()));
            } else {
                Class<?> entityClass = workflowEntityClasses.get(workflow.getEntityType());
                if (entityClass == null) {
                    return Option.empty();
                }
                return Option.of(new BasicMessagingContext<>(workflow.getId(),
                        entityManager.getReference(entityClass, workflow.getEntityId()), attempt, workflow.getWorkflowVersion()));
            }
        };
    }

}
