package ru.yandex.travel.orders.configurations;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.services.OperationTypes;
import ru.yandex.travel.orders.services.email.AsyncEmailOperation;
import ru.yandex.travel.orders.services.plus.YandexPlusInitTopupOperation;
import ru.yandex.travel.orders.services.promo.simple.PromoSendMailOperation;
import ru.yandex.travel.orders.services.promo.taxi2020.Taxi2020PromoSendMailOperation;
import ru.yandex.travel.orders.services.promo.taxi2020.Taxi2020PromoSendSmsOperation;
import ru.yandex.travel.orders.services.report.HotelPartnerPaymentOrderReportSender;
import ru.yandex.travel.orders.services.report.HotelPartnerPayoutReportSender;
import ru.yandex.travel.orders.services.report.HotelPartnerReportSender;
import ru.yandex.travel.orders.services.report.HotelPartnerReportSenderPlanner;
import ru.yandex.travel.orders.services.support.MirSupportNotificationSender;
import ru.yandex.travel.orders.services.train.GenericOfficeRefundStartService;
import ru.yandex.travel.orders.services.train.MockImGenericOfficeRefundStartService;
import ru.yandex.travel.workflow.single_operation.SingleOperationRunnerProvider;

@Configuration
public class OperationsConfiguration {

    @Autowired
    private HotelPartnerReportSender hotelPartnerReportSender;
    @Autowired
    private HotelPartnerReportSenderPlanner hotelPartnerReportSenderPlanner;
    @Autowired
    private HotelPartnerPayoutReportSender hotelPartnerPayoutReportSender;
    @Autowired
    private MockImGenericOfficeRefundStartService mockImGenericOfficeRefundStartService;
    @Autowired
    private GenericOfficeRefundStartService genericOfficeRefundStartService;
    @Autowired
    private Taxi2020PromoSendMailOperation taxi2020PromoSendMailOperation;
    @Autowired
    private Taxi2020PromoSendSmsOperation taxi2020PromoSendSmsOperation;
    @Autowired
    private PromoSendMailOperation promoSendMailOperation;
    @Autowired
    private MirSupportNotificationSender mirSupportNotificationSender;
    @Autowired
    private HotelPartnerPaymentOrderReportSender hotelPartnerPaymentOrderReportSender;
    @Autowired
    private AsyncEmailOperation asyncEmailOperation;
    @Autowired
    private YandexPlusInitTopupOperation yandexPlusInitTopupOperation;

    @Bean
    public SingleOperationRunnerProvider singleOperationRunnerProvider() {
        return operationType -> {
            // todo(tlg-13): use Map<Type, Operation> here, automatically collect and register operations
            if (OperationTypes.HOTELS_SEND_PARTNER_PAYOUT_DETAILS_REPORT.getValue().equals(operationType)) {
                return hotelPartnerReportSender;
            } else if (OperationTypes.HOTELS_PLAN_SENDING_REPORTS_TO_PARTNERS.getValue().equals(operationType)) {
                return hotelPartnerReportSenderPlanner;
            } else if (OperationTypes.HOTELS_SEND_PARTNER_PAYOUT_ORDER.getValue().equals(operationType)) {
                return hotelPartnerPayoutReportSender;
            } else if (OperationTypes.GENERIC_TRAINS_OFFICE_REFUND.getValue().equals(operationType)) {
                return genericOfficeRefundStartService;
            } else if (OperationTypes.MOCK_IM_START_OFFICE_REFUND.getValue().equals(operationType)) {
                return mockImGenericOfficeRefundStartService;
            } else if (OperationTypes.TAXI_2020_PROMO_CODE_EMAIL_SENDER.getValue().equals(operationType)) {
                return taxi2020PromoSendMailOperation;
            } else if (OperationTypes.TAXI_2020_PROMO_CODE_SMS_SENDER.getValue().equals(operationType)) {
                return taxi2020PromoSendSmsOperation;
            } else if (OperationTypes.SIMPLE_PROMO_EMAIL_SENDER.getValue().equals(operationType)) {
                return promoSendMailOperation;
            } else if (OperationTypes.MIR_SUPPORT_NOTIFICATION_SENDER.getValue().equals(operationType)) {
                return mirSupportNotificationSender;
            } else if (OperationTypes.HOTELS_SEND_PARTNER_PAYMENT_ORDERS_REPORT.getValue().equals(operationType)) {
                return hotelPartnerPaymentOrderReportSender;
            } else if (OperationTypes.ASYNC_EMAIL_SENDER.getValue().equals(operationType)) {
                return asyncEmailOperation;
            } else if (OperationTypes.YANDEX_PLUS_INIT_TOPUP.getValue().equals(operationType)) {
                return yandexPlusInitTopupOperation;
            } else {
                throw new RuntimeException(String.format("No runner found for operation type %s", operationType));
            }
        };
    }
}
