package ru.yandex.travel.orders.configurations;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.orders.services.pdfgenerator.PdfGeneratorConfigurationProperties;
import ru.yandex.travel.orders.services.pdfgenerator.PdfGeneratorService;
import ru.yandex.travel.orders.services.pdfgenerator.PdfGeneratorServiceImpl;

@Configuration
@EnableConfigurationProperties(PdfGeneratorConfigurationProperties.class)
public class PdfGeneratorConfiguration {
    @Bean
    public PdfGeneratorService pdfGeneratorService(@Qualifier("pdfGeneratorAhcClientWrapper") AsyncHttpClientWrapper pdfGeneratorAhcClient,
                                                   PdfGeneratorConfigurationProperties properties) {
        return new PdfGeneratorServiceImpl(pdfGeneratorAhcClient, properties);
    }
}
