package ru.yandex.travel.orders.configurations;

import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.services.avia.aeroflot.AeroflotMqProperties;

@Configuration
@EnableConfigurationProperties(AeroflotMqProperties.class)
public class SqsConfiguration {
    @Bean
    public AmazonSQS aeroflotOrderSyncSqsClient(AeroflotMqProperties properties) {
        return AmazonSQSClientBuilder
                .standard()
                .withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(properties.getSqsEndpoint(), properties.getSqsRegion()))
                .withCredentials(new AWSStaticCredentialsProvider(new BasicAWSCredentials(properties.getSqsUser(), properties.getSqsPassword())))
                .build();
    }
}
