package ru.yandex.travel.orders.configurations;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

import com.google.protobuf.CodedInputStream;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.dicts.rasp.proto.TTrainTariffInfo;

@Configuration
@EnableConfigurationProperties(TrainDictionaryProperties.class)
@Slf4j
public class TrainDictionariesConfiguration {

    // TODO (mbobrov): refactor that code to a more common way of working with entities
    private ArrayList<TTrainTariffInfo> parseTrainTariffInfos(FileInputStream in) throws IOException {
        ArrayList<TTrainTariffInfo> tariffInfos = new ArrayList<>();

        CodedInputStream cis = CodedInputStream.newInstance(in);
        TTrainTariffInfo object;
        while (!cis.isAtEnd()) {
            int size = cis.readFixed32();
            byte[] bytes = cis.readRawBytes(size);
            object = TTrainTariffInfo.parseFrom(ByteBuffer.wrap(bytes));
            tariffInfos.add(object);
        }
        return tariffInfos;
    }
}
