package ru.yandex.travel.orders.configurations;

import javax.validation.constraints.NotEmpty;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Getter
@Setter
@ConfigurationProperties(value = "train-dictionaries", ignoreUnknownFields = false)
@Validated
public class TrainDictionaryProperties {
    private boolean enabled;

    private TariffInfo tariffInfo;

    @Getter
    @Setter
    @Validated
    public static class TariffInfo {
        @NotEmpty
        private String dataFile;
    }
}
