package ru.yandex.travel.orders.configurations;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.dicts.rasp.proto.TTrainTariffInfo;
import ru.yandex.travel.orders.services.train.tariffinfo.DummyTrainTariffInfoDataProvider;
import ru.yandex.travel.orders.services.train.tariffinfo.TrainTariffInfoDataProvider;
import ru.yandex.travel.orders.services.train.tariffinfo.TrainTariffInfoService;
import ru.yandex.travel.yt_lucene_index.ProtobufYtLuceneIndexBuilder;

@Configuration
@EnableConfigurationProperties(TrainTariffInfoDataProviderProperties.class)
public class TrainTariffInfoDataProviderConfiguration {

    @Bean
    public TrainTariffInfoDataProvider trainTariffInfoDataProvider(TrainTariffInfoDataProviderProperties params) {
        if (params.isEnabled()) {
            ProtobufYtLuceneIndexBuilder<TTrainTariffInfo> luceneIndexBuilder = new ProtobufYtLuceneIndexBuilder<TTrainTariffInfo>()
                    .setProtoClass(TTrainTariffInfo.class);

            return new TrainTariffInfoService(params, luceneIndexBuilder);
        } else {
            return new DummyTrainTariffInfoDataProvider();
        }
    }

}
