package ru.yandex.travel.orders.configurations;

import java.util.Map;

import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.travel.orders.entities.AeroflotInvoice;
import ru.yandex.travel.orders.entities.AeroflotMqMessage;
import ru.yandex.travel.orders.entities.AeroflotOrder;
import ru.yandex.travel.orders.entities.BNovoOrderItem;
import ru.yandex.travel.orders.entities.BronevikOrderItem;
import ru.yandex.travel.orders.entities.BusOrderItem;
import ru.yandex.travel.orders.entities.BusTicketRefund;
import ru.yandex.travel.orders.entities.DolphinOrderItem;
import ru.yandex.travel.orders.entities.ExpediaOrderItem;
import ru.yandex.travel.orders.entities.GenericOrder;
import ru.yandex.travel.orders.entities.HotelOrder;
import ru.yandex.travel.orders.entities.PaymentSchedule;
import ru.yandex.travel.orders.entities.PendingInvoice;
import ru.yandex.travel.orders.entities.SimpleTrustRefund;
import ru.yandex.travel.orders.entities.SuburbanOrderItem;
import ru.yandex.travel.orders.entities.Ticket;
import ru.yandex.travel.orders.entities.TrainInsuranceRefund;
import ru.yandex.travel.orders.entities.TrainOrder;
import ru.yandex.travel.orders.entities.TrainOrderItem;
import ru.yandex.travel.orders.entities.TrainTicketRefund;
import ru.yandex.travel.orders.entities.TravellineOrderItem;
import ru.yandex.travel.orders.entities.TrustInvoice;
import ru.yandex.travel.orders.entities.Voucher;
import ru.yandex.travel.orders.entities.WellKnownWorkflowEntityType;
import ru.yandex.travel.orders.entities.YandexPlusTopup;
import ru.yandex.travel.orders.entities.notifications.Attachment;
import ru.yandex.travel.orders.entities.notifications.Notification;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandlerMatcher;
import ru.yandex.travel.workflow.entities.CommonWorkflowTypes;
import ru.yandex.travel.workflow.entities.SingleOperation;

@Configuration
public class WorkflowEventHandlersConfiguration {

    @Autowired
    @Qualifier("hotelOrderWorkflowEventHandler")
    WorkflowEventHandler<HotelOrder> hotelOrderWorkflowEventHandler;

    @Autowired
    @Qualifier("trainOrderWorkflowEventHandler")
    WorkflowEventHandler<TrainOrder> trainOrderWorkflowEventHandler;

    @Autowired
    @Qualifier("trainOrderItemWorkflowEventHandler")
    WorkflowEventHandler<TrainOrderItem> trainOrderItemWorkflowEventHandler;

    @Autowired
    @Qualifier("trainInsuranceRefundWorkflowEventHandler")
    WorkflowEventHandler<TrainInsuranceRefund> trainInsuranceRefundWorkflowEventHandler;

    @Autowired
    @Qualifier("trainTicketRefundWorkflowEventHandler")
    WorkflowEventHandler<TrainTicketRefund> trainTicketRefundWorkflowEventHandler;

    @Autowired
    @Qualifier("suburbanOrderItemWorkflowEventHandler")
    WorkflowEventHandler<SuburbanOrderItem> suburbanOrderItemWorkflowEventHandler;

    @Autowired
    @Qualifier("busTicketRefundWorkflowEventHandler")
    WorkflowEventHandler<BusTicketRefund> busTicketRefundWorkflowEventHandler;

    @Autowired
    @Qualifier("busOrderItemWorkflowEventHandler")
    WorkflowEventHandler<BusOrderItem> busOrderItemWorkflowEventHandler;

    @Autowired
    @Qualifier("genericOrderWorkflowEventHandler")
    WorkflowEventHandler<GenericOrder> genericOrderWorkflowEventHandler;

    @Autowired
    @Qualifier("trustInvoiceWorkflowEventHandler")
    WorkflowEventHandler<TrustInvoice> trustInvoiceWorkflowEventHandler;

    @Autowired
    @Qualifier("yandexPlusTopupWorkflowEventHandler")
    WorkflowEventHandler<YandexPlusTopup> yandexPlusTopupWorkflowEventHandler;

    @Autowired
    @Qualifier("expediaWorkflowEventHandler")
    WorkflowEventHandler<ExpediaOrderItem> expediaWorkflowEventHandler;

    @Autowired
    @Qualifier("aeroflotOrderWorkflowEventHandler")
    WorkflowEventHandler<AeroflotOrder> aeroflotOrderWorkflowEventHandler;

    @Autowired
    @Qualifier("aeroflotServiceWorkflowEventHandler")
    WorkflowEventHandler<ExpediaOrderItem> aeroflotServiceWorkflowEventHandler;

    @Autowired
    @Qualifier("aeroflotInvoiceWorkflowEventHandler")
    WorkflowEventHandler<AeroflotInvoice> aeroflotInvoiceWorkflowEventHandler;

    @Autowired
    @Qualifier("aeroflotMqMessageWorkflowEventHandler")
    WorkflowEventHandler<AeroflotMqMessage> aeroflotMqMessageWorkflowEventHandler;

    @Autowired
    @Qualifier("trustRefundWorkflowEventHandler")
    WorkflowEventHandler<SimpleTrustRefund> trustRefundWorkflowEventHandler;

    @Autowired
    @Qualifier("ticketWorkflowEventHandler")
    WorkflowEventHandler<Ticket> ticketWorkflowEventHandler;

    @Autowired
    @Qualifier("orderSupervisorWorkflowEventHandler")
    WorkflowEventHandler<Void> orderSupervisorWorkflowEventHandler;

    @Autowired
    @Qualifier("voucherWorkflowEventHandler")
    WorkflowEventHandler<Voucher> voucherWorkflowEventHandler;

    @Autowired
    @Qualifier("genericErrorSupervisorWorkflowEventHandler")
    WorkflowEventHandler<Void> genericErrorSupervisorWorkflowEventHandler;

    @Autowired
    @Qualifier("dolphinOrderItemWorkflowEventHandler")
    WorkflowEventHandler<DolphinOrderItem> dolphinWorkflowEventHandler;

    @Autowired
    @Qualifier("travellineOrderItemWorkflowEventHandler")
    WorkflowEventHandler<TravellineOrderItem> travellineWorkflowEventHandler;

    @Autowired
    @Qualifier("bNovoOrderItemWorkflowEventHandler")
    WorkflowEventHandler<BNovoOrderItem> bNovoWorkflowEventHandler;

    @Autowired
    @Qualifier("bronevikOrderItemWorkflowEventHandler")
    WorkflowEventHandler<BronevikOrderItem> bronevikWorkflowEventHandler;

    @Autowired
    @Qualifier("notificationWorkflowEventHandler")
    WorkflowEventHandler<Notification> notificationWorkflowEventHandler;

    @Autowired
    @Qualifier("attachmentWorkflowEventHandler")
    WorkflowEventHandler<Attachment> attachmentWorkflowEventHandler;

    @Autowired
    @Qualifier("singleOperationWorkflowHandler")
    WorkflowEventHandler<SingleOperation> singleOperationWorkflowEventHandler;

    @Autowired
    @Qualifier("pendingInvoiceWorkflowEventHandler")
    WorkflowEventHandler<PendingInvoice> pendingInvoiceWorkflowEventHandler;

    @Autowired
    @Qualifier("paymentScheduleWorkflowEventHandler")
    WorkflowEventHandler<PaymentSchedule> paymentScheduleWorkflowEventHandler;

    @Bean
    public WorkflowEventHandlerMatcher workflowEventHandlerMatcher() {
        Map<String, WorkflowEventHandler<?>> handlers = ImmutableMap.<String, WorkflowEventHandler<?>>builder()
                // hotels
                .put(WellKnownWorkflowEntityType.HOTEL_ORDER.getDiscriminatorValue(), hotelOrderWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.EXPEDIA_ORDER_ITEM.getDiscriminatorValue(),
                        expediaWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.DOLPHIN_ORDER_ITEM.getDiscriminatorValue(),
                        dolphinWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.TRAVELLINE_ORDER_ITEM.getDiscriminatorValue(),
                        travellineWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.VOUCHER.getDiscriminatorValue(), voucherWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.BNOVO_ORDER_ITEM.getDiscriminatorValue(), bNovoWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.BRONEVIK_ORDER_ITEM.getDiscriminatorValue(), bronevikWorkflowEventHandler)
                // avia
                .put(WellKnownWorkflowEntityType.AEROFLOT_ORDER.getDiscriminatorValue(),
                        aeroflotOrderWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.AEROFLOT_ORDER_ITEM.getDiscriminatorValue(),
                        aeroflotServiceWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.AEROFLOT_INVOICE.getDiscriminatorValue(),
                        aeroflotInvoiceWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.AEROFLOT_MQ_MESSAGE.getDiscriminatorValue(),
                        aeroflotMqMessageWorkflowEventHandler)
                // bus
                .put(WellKnownWorkflowEntityType.BUS_ORDER_ITEM.getDiscriminatorValue(),
                        busOrderItemWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.BUS_TICKET_REFUND.getDiscriminatorValue(),
                        busTicketRefundWorkflowEventHandler)
                // generic
                .put(WellKnownWorkflowEntityType.GENERIC_ORDER.getDiscriminatorValue(),
                        genericOrderWorkflowEventHandler)
                // train
                .put(WellKnownWorkflowEntityType.TRAIN_ORDER.getDiscriminatorValue(),
                        trainOrderWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.TRAIN_ORDER_ITEM.getDiscriminatorValue(),
                        trainOrderItemWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.TRAIN_INSURANCE_REFUND.getDiscriminatorValue(),
                        trainInsuranceRefundWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.TRAIN_TICKET_REFUND.getDiscriminatorValue(),
                        trainTicketRefundWorkflowEventHandler)
                //suburban
                .put(WellKnownWorkflowEntityType.SUBURBAN_ORDER_ITEM.getDiscriminatorValue(),
                        suburbanOrderItemWorkflowEventHandler)
                // payments
                .put(WellKnownWorkflowEntityType.TRUST_INVOICE.getDiscriminatorValue(),
                        trustInvoiceWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.TRUST_REFUND.getDiscriminatorValue(), trustRefundWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.PLUS_POINTS_TOPUP.getDiscriminatorValue(),
                        yandexPlusTopupWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.PENDING_INVOICE.getDiscriminatorValue(),
                        pendingInvoiceWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.PAYMENT_SCHEDULE.getDiscriminatorValue(),
                        paymentScheduleWorkflowEventHandler)
                // tickets
                .put(WellKnownWorkflowEntityType.STARTREK_ISSUE.getDiscriminatorValue(), ticketWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.ORDER_SUPERVISOR.getDiscriminatorValue(),
                        orderSupervisorWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.GENERIC_ERROR_SUPERVISOR.getDiscriminatorValue(),
                        genericErrorSupervisorWorkflowEventHandler)
                // notifications
                .put(WellKnownWorkflowEntityType.NOTIFICATION.getDiscriminatorValue(),
                        notificationWorkflowEventHandler)
                .put(WellKnownWorkflowEntityType.ATTACHMENT.getDiscriminatorValue(),
                        attachmentWorkflowEventHandler)
                .put(CommonWorkflowTypes.SINGLE_OPERATION.getDiscriminatorValue(),
                        singleOperationWorkflowEventHandler)
                .build();
        return (workflow, event) -> Option.ofNullable(handlers.get(workflow.getEntityType()));
    }
}
