package ru.yandex.travel.orders.configurations;

import com.google.common.base.Preconditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.ydb.DefaultYdbLogService;
import ru.yandex.travel.commons.logging.ydb.MockYdbLogService;
import ru.yandex.travel.commons.logging.ydb.YdbLogProperties;
import ru.yandex.travel.commons.logging.ydb.YdbLogService;

@Configuration
public class YdbLogReaderConfiguration {

    @ConditionalOnProperty(prefix = "ydb-log", name = "enabled", havingValue = "true")
    @EnableConfigurationProperties({YdbLogReaderConfigurationProperties.class, TvmServiceProperties.class})
    public static class EnabledConfig {
        @Bean
        public YdbLogService ydbLogService(YdbLogReaderConfigurationProperties properties,
                                           TvmServiceProperties tvmProperties) {
            Preconditions.checkNotNull(tvmProperties, "Tvm-service should be enabled for ydb-logging");
            var ydbLogProperties = YdbLogProperties.builder()
                    .dbEndpoint(properties.getEndpoint())
                    .dbPath(properties.getDb())
                    .tablePath(properties.getTable())
                    .tvmClientId(tvmProperties.getClientId())
                    .tvmSecret(tvmProperties.getClientSecret())
                    .maxAttempts(properties.getMaxAttempts())
                    .clientTimeout(properties.getClientTimeout())
                    .shutdownTimeout(properties.getShutdownTimeout())
                    .backoffSlot(properties.getBackoffSlot())
                    .backoffCeiling(properties.getBackoffCeiling())
                    .build();
            return new DefaultYdbLogService(ydbLogProperties);
        }
    }

    @ConditionalOnProperty(prefix = "ydb-log", name = "enabled", havingValue = "false")
    public static class DisabledConfig {
        @Bean
        public YdbLogService mockYdbLogService() {
            return new MockYdbLogService();
        }
    }
}
