package ru.yandex.travel.orders.configurations;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "ydb-log", ignoreUnknownFields = false)
@Data
@Validated
public class YdbLogReaderConfigurationProperties {
    private boolean enabled;
    @NotEmpty
    private String endpoint;
    @NotEmpty
    private String db;
    @NotEmpty
    private String table;
    private int maxAttempts;
    private Duration clientTimeout;
    private Duration backoffSlot;
    private int backoffCeiling;
    private Duration shutdownTimeout;
}
