package ru.yandex.travel.orders.configurations.jdbc;

public enum TxScopeType {
    DEFAULT,
    /**
     * we're gonna use this scope for read-only requests from grpc. This should go to the read-only replica
     *
     * @implNote {@link ru.yandex.travel.orders.grpc.CallType#READ_ONLY CallType} eventually should mean that the method
     * can use read-only transaction. But not ATM. Therefore, usage of read only transactions should be declared
     * explicitly in
     * {@link ru.yandex.travel.orders.grpc.helpers.TxCallWrapper#synchronouslyWithTx(ru.yandex.travel.orders.infrastructure.CallDescriptor, io.grpc.stub.StreamObserver, org.slf4j.Logger, java.util.function.Function, TxScopeType) synchronouslyWithTx}.
     */
    READ_ONLY,
    /**
     * GRPC services execute transaction using this scope (usually separate jdbc processing pool and datasource)
     */
    GRPC
}
