package ru.yandex.travel.orders.configurations.stress;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import ru.yandex.travel.orders.services.MailSenderService;
import ru.yandex.travel.orders.services.mock.MockMailSenderService;

@Configuration
@ConditionalOnProperty(prefix = "mock-mail-sender", name = "enabled", havingValue = "true")
@EnableConfigurationProperties(MockMailSenderProperties.class)
public class MockMailSenderConfiguration {

    @Bean
    @Primary
    public MailSenderService mockMailSenderService(MockMailSenderProperties properties) {
        return new MockMailSenderService(properties.getCallDelayMin(), properties.getCallDelayMax());
    }
}
