package ru.yandex.travel.orders.configurations.stress;

import java.io.IOException;

import com.google.common.io.ByteStreams;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import ru.yandex.travel.orders.services.mock.MockPdfGenerator;
import ru.yandex.travel.orders.services.pdfgenerator.PdfGeneratorService;

@Configuration
@ConditionalOnProperty(prefix = "mock-pdf-generator", name = "enabled", havingValue = "true")
@EnableConfigurationProperties(MockPdfGeneratorProperties.class)
public class MockPdfGeneratorConfiguration {

    @Bean
    public Resource mockVoucherPdf() {
        return new ClassPathResource("stress/voucher.pdf");
    }

    @Bean
    @Primary
    public PdfGeneratorService mockPdfGeneratorService(MockPdfGeneratorProperties properties,
                                                       Resource mockVoucherPdf) throws IOException {
        return new MockPdfGenerator(properties.getCallDelayMin(), properties.getCallDelayMax(),
                ByteStreams.toByteArray(mockVoucherPdf.getInputStream())
        );
    }

}
