package ru.yandex.travel.orders.configurations.stress;

import java.time.Duration;

import javax.validation.constraints.NotNull;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Data
@ConfigurationProperties(prefix = "mock-pdf-generator", ignoreUnknownFields = false)
@Validated
public class MockPdfGeneratorProperties {

    private boolean enabled;

    @NotNull
    private Duration callDelayMin;

    @NotNull
    private Duration callDelayMax;
}
