package ru.yandex.travel.orders.configurations.stress;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import ru.yandex.travel.orders.services.mock.MockTrustClient;
import ru.yandex.travel.orders.services.payments.TrustClient;
import ru.yandex.travel.orders.services.payments.TrustClientProvider;

@Configuration
@ConditionalOnProperty(prefix = "mock-trust", name = "enabled", havingValue = "true")
@EnableConfigurationProperties(MockTrustProperties.class)
public class MockTrustConfiguration {

    @Bean
    public TrustClient mockTrustClient(MockTrustProperties mockTrustProperties) {
        return new MockTrustClient(mockTrustProperties, true);
    }

    @Bean
    @Primary
    public TrustClientProvider mockTrustClientProvider(@Qualifier("mockTrustClient") TrustClient trustClient) {
        return paymentProfile -> trustClient;
    }
}
