package ru.yandex.travel.orders.configurations.stress;

import java.time.Duration;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Data
@ConfigurationProperties(prefix = "mock-trust", ignoreUnknownFields = false)
@Validated
public class MockTrustProperties {

    private boolean enabled;

    @Positive
    private int maxPayments = 1000;

    @Positive
    private int maxRefunds = 1000;

    @NotNull
    private Duration callDelayMin = Duration.ZERO;

    @NotNull
    private Duration callDelayMax = Duration.ZERO;

    @NotNull
    private Duration paymentDelayMin = Duration.ZERO;

    @NotNull
    private Duration paymentDelayMax = Duration.ZERO;
}
