package ru.yandex.travel.orders.entities;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name = "account_records")
@Data
@NoArgsConstructor
@EqualsAndHashCode(exclude = {"account", "accountTransaction"})
@ToString(exclude = {"account", "accountTransaction"})
public class AccountRecord {

    @Id
    @GeneratedValue(
            strategy = GenerationType.SEQUENCE,
            generator = "account_records_id_seq"
    )
    @SequenceGenerator(
            name = "account_records_id_seq",
            sequenceName = "account_records_id_seq",
            allocationSize = 1
    )
    private Long id;

    @CreationTimestamp
    private LocalDateTime createdAt;

    @UpdateTimestamp
    private LocalDateTime updatedAt;

    private BigDecimal delta;

    @ManyToOne
    private Account account;

    @ManyToOne
    private AccountTransaction accountTransaction;

    public AccountRecord(Account account, BigDecimal delta) {
        this.delta = delta;
        account.addRecord(this);
    }

}
