package ru.yandex.travel.orders.entities;

import java.util.HashSet;
import java.util.Set;

import com.google.common.collect.ImmutableSet;

import ru.yandex.travel.orders.admin.proto.EPartnerType;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;
import ru.yandex.travel.orders.commons.proto.EOrderType;

public class AdminFilterValues {
    private final Set<EOrderType> orderTypeValues;
    private final Set<EDisplayOrderState> orderStateValues;
    private final Set<EPartnerType> partnerTypeValues;

    public AdminFilterValues() {
        this.orderTypeValues = new HashSet<>();
        this.orderStateValues = new HashSet<>();
        this.partnerTypeValues = new HashSet<>();
    }

    public void addOrderType(EOrderType orderType) {
        this.orderTypeValues.add(orderType);
    }

    public void addOrderState(EDisplayOrderState orderState) {
        this.orderStateValues.add(orderState);
    }

    public void addPartnerType(EPartnerType partnerType) {
        this.partnerTypeValues.add(partnerType);
    }

    public Set<EOrderType> getTypes() {
        return ImmutableSet.copyOf(this.orderTypeValues);
    }

    public Set<EDisplayOrderState> getStates() {
        return ImmutableSet.copyOf(this.orderStateValues);
    }

    public Set<EPartnerType> getPartners() {
        return ImmutableSet.copyOf(this.partnerTypeValues);
    }
}
