package ru.yandex.travel.orders.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;

import com.google.common.collect.ImmutableMap;
import org.hibernate.query.criteria.internal.OrderImpl;

import ru.yandex.travel.orders.admin.proto.TAdminSorterType;
import ru.yandex.travel.orders.commons.proto.ESortDirection;

public class AdminListOrdersParams {
    private static final ImmutableMap<TAdminSorterType.ESortField, String> adminSortFieldToFieldNameMap = ImmutableMap.of(
            TAdminSorterType.ESortField.SF_CREATED_AT, "createdAt"
    );
    private List<UUID> orderIdList;

    private List<TAdminSorterType> sorterList;

    public AdminListOrdersParams(List<UUID> orderIds, List<TAdminSorterType> sorters) {
        this.orderIdList = orderIds;
        this.sorterList = sorters;
    }

    public List<UUID> getOrderIdList() {
        return orderIdList;
    }

    public List<Order> prepareSorters(Root root) {
        if (sorterList != null) {
            return this.sorterList.stream()
                    .map(sorter -> prepareSorter(sorter, root))
                    .collect(Collectors.toList());
        } else {
            return new ArrayList<>();
        }
    }

    private Order prepareSorter(TAdminSorterType sorter, Root root) {
        return new OrderImpl(root.get(adminSortFieldToFieldNameMap.get(sorter.getSortField())), sorter.getSortDirection() == ESortDirection.SD_ASC);
    }
}
