package ru.yandex.travel.orders.entities;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import org.hibernate.annotations.Type;

import ru.yandex.travel.orders.commons.proto.EAdminRole;

@Entity
@Table(name = "admin_users")
@Data
public class AdminUser {
    @Id
    private String login;

    @ElementCollection(targetClass = EAdminRole.class)
    @Type(type = "proto-enum")
    @Getter(AccessLevel.NONE)
    private Set<EAdminRole> roles;

    private boolean superuser;

    public Set<EAdminRole> getRoles() {
        if (this.roles == null) {
            this.roles = new HashSet<>();
        }
        return this.roles;
    }

    public boolean addRole(EAdminRole role) {
        return getRoles().add(role);
    }

    public boolean removeRole(EAdminRole role) {
        return getRoles().remove(role);
    }
}
