package ru.yandex.travel.orders.entities;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import lombok.Data;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;

import ru.yandex.travel.orders.commons.proto.EAdminAction;

@Entity
@Table(name = "admin_user_action_audit_records")
@Data
public class AdminUserActionAuditRecord {

    @Id
    @GeneratedValue(
            strategy = GenerationType.SEQUENCE,
            generator = "admin_user_action_audit_id_seq"
    )
    @SequenceGenerator(
            name = "admin_user_action_audit_id_seq",
            sequenceName = "admin_user_action_audit_id_seq",
            allocationSize = 1
    )
    Long id;

    @CreationTimestamp
    private Instant createdAt;

    private UUID orderId;
    private String userLogin;

    @Type(type = "proto-enum")
    private EAdminAction action;

    private String description;


}
