package ru.yandex.travel.orders.entities;

import java.util.List;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Type;

import ru.yandex.travel.orders.proto.EInvoiceType;
import ru.yandex.travel.orders.services.payments.PaymentProfile;
import ru.yandex.travel.orders.workflow.invoice.aeroflot.proto.EAeroflotInvoiceState;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

@Entity
@DiscriminatorValue(WellKnownInvoiceDiscriminator.INVOICE_AEROFLOT)
@Getter
@Setter
@BatchSize(size = 100)
public class AeroflotInvoice extends Invoice implements WorkflowEntity<EAeroflotInvoiceState> {
    @Type(type = "proto-enum")
    private EAeroflotInvoiceState state = EAeroflotInvoiceState.IS_NEW;

    private String confirmationUrl;

    public static AeroflotInvoice createInvoice(Order order, List<InvoiceItemProvider> source, AuthorizedUser owner, boolean useNewPaymentForm) {
        AeroflotInvoice result = new AeroflotInvoice();
        result.setPaymentProfile(PaymentProfile.AEROFLOT);
        result.setNewPaymentWebForm(useNewPaymentForm);
        return initInvoice(order, result, source, owner);
    }


    @Override
    public String getEntityType() {
        return WellKnownWorkflowEntityType.AEROFLOT_INVOICE.getDiscriminatorValue();
    }

    @Override
    public EInvoiceType getPublicType() {
        return EInvoiceType.IT_AVIA_AEROFLOT;
    }

    @Override
    public EAeroflotInvoiceState getInvoiceState() {
        return state;
    }

    @Override
    public AeroflotOrder getOrder() {
        return (AeroflotOrder) super.getOrder();
    }
}
