package ru.yandex.travel.orders.entities;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;

import ru.yandex.travel.orders.workflow.orderitem.aeroflot.mq.proto.EAeroflotMqMessageState;
import ru.yandex.travel.workflow.entities.Workflow;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

@Entity
@Table(name = "aeroflot_mq_messages")
@Getter
@Setter
public class AeroflotMqMessage implements WorkflowEntity<EAeroflotMqMessageState> {
    @Id
    private UUID id;

    @OneToOne
    private Workflow workflow;

    private Instant lastTransitionAt;

    @Type(type = "proto-enum")
    private EAeroflotMqMessageState state;

    @CreationTimestamp
    private Instant createdAt;
    @UpdateTimestamp
    private Instant updatedAt;

    private String data;
    private UUID orderItemId;
    private UUID ticketId;

    @Version
    private Integer version;

    public String getEntityType() {
        return WellKnownWorkflowEntityType.AEROFLOT_MQ_MESSAGE.getDiscriminatorValue();
    }

    @Override
    public Instant getLastTransitionAt() {
        if (lastTransitionAt == null) {
            return createdAt;
        }
        return lastTransitionAt;
    }
}
