package ru.yandex.travel.orders.entities;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import com.google.common.base.Preconditions;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Type;

import ru.yandex.travel.orders.commons.proto.EOrderType;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

@Entity
@Getter
@Setter
@DiscriminatorValue(value = "aeroflot_order")
public class AeroflotOrder extends Order implements WorkflowEntity<EAeroflotOrderState> {
    @Type(type = "proto-enum")
    private EAeroflotOrderState state;

    @Override
    public EOrderType getPublicType() {
        return EOrderType.OT_AVIA_AEROFLOT;
    }

    @Override
    public String getEntityType() {
        return WellKnownWorkflowEntityType.AEROFLOT_ORDER.getDiscriminatorValue();
    }

    @Override
    public EAeroflotOrderState getEntityState() {
        return state;
    }

    public AeroflotOrderItem getAeroflotOrderItem() {
        Preconditions.checkArgument(getOrderItems().size() == 1,
                "Exactly one order item is expected but got %s", getOrderItems().size());
        return (AeroflotOrderItem) getOrderItems().get(0);
    }
}
