package ru.yandex.travel.orders.entities;

import java.time.LocalDateTime;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Type;
import org.javamoney.moneta.Money;

import ru.yandex.avia.booking.partners.gateways.aeroflot.model.AeroflotSegmentNode;
import ru.yandex.avia.booking.partners.gateways.aeroflot.model.AeroflotServicePayload;
import ru.yandex.travel.orders.commons.proto.EServiceType;
import ru.yandex.travel.orders.entities.partners.AeroflotBillingPartnerAgreement;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotItemState;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

@DiscriminatorValue(WellKnownOrderItemDiscriminator.ORDER_ITEM_AEROFLOT)
@Getter
@Setter
@Entity
public class AeroflotOrderItem extends OrderItem implements WorkflowEntity<EAeroflotItemState> {
    @Type(type = "proto-enum")
    private EAeroflotItemState state;

    @Type(type = "jsonb-object")
    @Column(name = "payload")
    private AeroflotServicePayload payload;

    @Type(type = "jsonb-object")
    @Column(name = "agreement")
    private AeroflotBillingPartnerAgreement billingPartnerAgreement;

    private String aviaPnr;

    @Override
    public AeroflotOrder getOrder() {
        return (AeroflotOrder) super.getOrder();
    }

    @Override
    public AeroflotServicePayload getPayload() {
        return payload;
    }

    public void setPayload(AeroflotServicePayload payload) {
        this.payload = payload;
    }

    @Override
    public String getEntityType() {
        return WellKnownWorkflowEntityType.AEROFLOT_ORDER_ITEM.getDiscriminatorValue();
    }

    @Override
    public EServiceType getPublicType() {
        return EServiceType.PT_FLIGHT;
    }

    @Override
    public LocalDateTime getServicedAt() {
        // TODO set real date, as now there's string here
        AeroflotSegmentNode firstSegment = payload.getVariant().getSegments().get(0).getDeparture();
        return firstSegment.getDateTime();
    }

    @Override
    public EAeroflotItemState getItemState() {
        return state;
    }

    @Override
    public Money totalCostAfterReservation() {
        return payload.getVariant().getOffer().getTotalPrice();
    }

    @Override
    public Money preliminaryTotalCost() {
        return payload.getVariant().getOffer().getTotalPrice();
    }
}
