package ru.yandex.travel.orders.entities;

import java.time.LocalDateTime;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Type;

import ru.yandex.travel.hotels.common.orders.BronevikHotelItinerary;
import ru.yandex.travel.hotels.common.orders.HotelItinerary;
import ru.yandex.travel.hotels.proto.EPartnerId;
import ru.yandex.travel.orders.commons.proto.EServiceType;
import ru.yandex.travel.orders.entities.partners.BronevikBillingPartnerAgreement;
import ru.yandex.travel.orders.workflow.hotels.bronevik.proto.EBronevikItemState;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

@Entity
@DiscriminatorValue(WellKnownOrderItemDiscriminator.ORDER_ITEM_BRONEVIK)
@Getter
@Setter
public class BronevikOrderItem extends HotelOrderItem implements WorkflowEntity<EBronevikItemState> {
    @Type(type = "proto-enum")
    private EBronevikItemState state;

    @Type(type = "jsonb-object")
    @Column(name = "payload")
    private BronevikHotelItinerary itinerary;

    @Type(type = "jsonb-object")
    @Column(name = "agreement")
    private BronevikBillingPartnerAgreement billingPartnerAgreement;

    @Override
    public HotelOrderItemState getPublicState() {
        //noinspection DuplicatedCode
        switch (getState()) {
            case IS_NEW:
                return HotelOrderItemState.NEW;
            case IS_CHECKED_OFFER:
                return HotelOrderItemState.RESERVED;
            case IS_CONFIRMED:
                return HotelOrderItemState.CONFIRMED;
            case IS_CANCELLED:
                return HotelOrderItemState.CANCELLED;
            case IS_REFUNDED:
                return HotelOrderItemState.REFUNDED;
            default:
                return HotelOrderItemState.OTHER;
        }
    }

    @Override
    public HotelItinerary getHotelItinerary() {
        return itinerary;
    }

    @Override
    public EPartnerId getPartnerId() {
        return EPartnerId.PI_BRONEVIK;
    }

    @Override
    public Enum getItemState() {
        return state;
    }

    @Override
    public EServiceType getPublicType() {
        return EServiceType.PT_BRONEVIK_HOTEL;
    }

    @Override
    public String getEntityType() {
        return WellKnownWorkflowEntityType.BRONEVIK_ORDER_ITEM.getDiscriminatorValue();
    }

    @Override
    public EBronevikItemState getState() {
        return state;
    }

    @Override
    public void setState(EBronevikItemState state) {
        this.state = state;
    }

    @Override
    public Object getPayload() {
        return itinerary;
    }

    @Override
    public LocalDateTime getServicedAt() {
        return itinerary.getOrderDetails().getCheckoutDate().atStartOfDay();
    }

}
