package ru.yandex.travel.orders.entities;


import java.time.LocalDateTime;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Type;

import ru.yandex.travel.hotels.common.orders.DolphinHotelItinerary;
import ru.yandex.travel.hotels.proto.EPartnerId;
import ru.yandex.travel.orders.commons.proto.EServiceType;
import ru.yandex.travel.orders.entities.partners.DolphinBillingPartnerAgreement;
import ru.yandex.travel.orders.workflow.hotels.dolphin.proto.EDolphinItemState;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

@DiscriminatorValue(WellKnownOrderItemDiscriminator.ORDER_ITEM_DOLPHIN)
@Getter
@Setter
@Entity
public class DolphinOrderItem extends HotelOrderItem implements WorkflowEntity<EDolphinItemState> {
    @Type(type = "proto-enum")
    private EDolphinItemState state;

    @Type(type = "jsonb-object")
    @Column(name = "payload")
    private DolphinHotelItinerary itinerary;

    private String dolphinOrderCode;

    @Type(type = "jsonb-object")
    @Column(name = "agreement")
    private DolphinBillingPartnerAgreement billingPartnerAgreement;

    @Override
    public Object getPayload() {
        return itinerary;
    }

    @Override
    public EDolphinItemState getItemState() {
        return state;
    }

    @Override
    public EServiceType getPublicType() {
        return EServiceType.PT_DOLPHIN_HOTEL;
    }

    @Override
    public LocalDateTime getServicedAt() {
        return itinerary.getCheckinDate().atStartOfDay();
    }

    @Override
    public String getEntityType() {
        return WellKnownWorkflowEntityType.DOLPHIN_ORDER_ITEM.getDiscriminatorValue();
    }

    @Override
    public EDolphinItemState getState() {
        return state;
    }

    @Override
    public void setState(EDolphinItemState state) {
        this.state = state;
    }

    @Override
    public HotelOrderItemState getPublicState() {
        //noinspection DuplicatedCode
        switch (getState()) {
            case IS_RESERVED:
                return HotelOrderItemState.RESERVED;
            case IS_NEW:
                return HotelOrderItemState.NEW;
            case IS_CONFIRMED:
                return HotelOrderItemState.CONFIRMED;
            case IS_CANCELLED:
                return HotelOrderItemState.CANCELLED;
            case IS_REFUNDED:
                return HotelOrderItemState.REFUNDED;
            default:
                return HotelOrderItemState.OTHER;
        }
    }

    @Override
    public DolphinHotelItinerary getHotelItinerary() {
        return itinerary;
    }

    @Override
    public EPartnerId getPartnerId() {
        return EPartnerId.PI_DOLPHIN;
    }
}
