package ru.yandex.travel.orders.entities;

import java.time.LocalDateTime;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Type;

import ru.yandex.travel.hotels.common.orders.ExpediaHotelItinerary;
import ru.yandex.travel.hotels.common.orders.HotelItinerary;
import ru.yandex.travel.hotels.proto.EPartnerId;
import ru.yandex.travel.orders.commons.proto.EServiceType;
import ru.yandex.travel.orders.entities.partners.ExpediaBillingPartnerAgreement;
import ru.yandex.travel.orders.workflow.hotels.expedia.proto.EExpediaItemState;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

@DiscriminatorValue(WellKnownOrderItemDiscriminator.ORDER_ITEM_EXPEDIA)
@Getter
@Setter
@Entity
public class ExpediaOrderItem extends HotelOrderItem implements WorkflowEntity<EExpediaItemState> {
    @Type(type = "proto-enum")
    private EExpediaItemState state;

    @Type(type = "jsonb-object")
    @Column(name = "payload")
    private ExpediaHotelItinerary itinerary;

    @Type(type = "jsonb-object")
    @Column(name = "agreement")
    private ExpediaBillingPartnerAgreement billingPartnerAgreement;

    @Override
    public Object getPayload() {
        return itinerary;
    }

    @Override
    public String getEntityType() {
        return WellKnownWorkflowEntityType.EXPEDIA_ORDER_ITEM.getDiscriminatorValue();
    }

    @Override
    public EServiceType getPublicType() {
        return EServiceType.PT_EXPEDIA_HOTEL;
    }

    @Override
    public LocalDateTime getServicedAt() {
        // TODO (mbobrov): ask tivelkov, sandello on proper meaning
        return itinerary.getOrderDetails().getCheckinDate().atStartOfDay();
    }

    @Override
    public EExpediaItemState getItemState() {
        return state;
    }

    @Override
    public HotelOrderItemState getPublicState() {
        switch (getState()) {
            case IS_RESERVED:
                return HotelOrderItemState.RESERVED;
            case IS_NEW:
                return HotelOrderItemState.NEW;
            case IS_CONFIRMED:
                return HotelOrderItemState.CONFIRMED;
            case IS_CANCELLED:
                return HotelOrderItemState.CANCELLED;
            case IS_REFUNDED:
                return HotelOrderItemState.REFUNDED;
            default:
                return HotelOrderItemState.OTHER;
        }
    }

    @Override
    public HotelItinerary getHotelItinerary() {
        return itinerary;
    }

    @Override
    public EPartnerId getPartnerId() {
        return EPartnerId.PI_EXPEDIA;
    }
}
