package ru.yandex.travel.orders.entities;

import java.util.Set;

public enum FiscalItemType {
    EXPEDIA_HOTEL("expedia_hotel", "PLACEMENT_EXPEDIA"),
    HOTEL_MEAL("hotel_meal", "hotel_meal"),
    FLIGHT_AEROFLOT("flight_aeroflot", "FLIGHT_AEROFLOT"),
    COMMISSION_EXPEDIA("commission_expedia", "COMMISSION_EXPEDIA"),

    TRAIN_TICKET("train_ticket", "im_ticket"),
    TRAIN_SERVICE("train_service", "im_service"),
    TRAIN_FEE("train_fee", "im_rasp_fee"),
    TRAIN_INSURANCE("train_insurance", "im_insurance"),

    SUBURBAN_MOVISTA_TICKET("suburban_movista_ticket", "movista_ticket"),
    SUBURBAN_IM_TICKET("suburban_im_ticket", "im_ticket"),
    SUBURBAN_AEROEXPRESS_TICKET("suburban_aeroexpress_ticket", "aeroex_id"),
    // used when only one provider existed
    SUBURBAN_TICKET_OLD("suburban_ticket", "movista_ticket"),

    BUS_ATLASBUS_TICKET("bus-atlasbus-ticket", "atlasbus-ticket"),
    BUS_ATLASBUS_PARTNER_FEE("bus-atlasbus-partner-fee", "atlasbus-partner-fee"),
    BUS_ATLASBUS_YANDEX_FEE("bus-atlasbus-yandex-fee", "atlasbus-yandex-fee"),
    BUS_BUSFOR_TICKET("bus-busfor-ticket", "busfor-ticket"),
    BUS_BUSFOR_PARTNER_FEE("bus-busfor-partner-fee", "busfor-partner-fee"),
    BUS_BUSFOR_YANDEX_FEE("bus-busfor-yandex-fee", "busfor-yandex-fee"),
    BUS_ECOLINES_TICKET("bus-ecolines-ticket", "ecolines-ticket-v2"),
    BUS_ECOLINES_PARTNER_FEE("bus-ecolines-partner-fee", "ecolines-partner-fee-v2"),
    BUS_ECOLINES_YANDEX_FEE("bus-ecolines-yandex-fee", "ecolines-yandex-fee-v2"),
    BUS_ETRAFFIC_TICKET("bus-etraffic-ticket", "etraffic-ticket"),
    BUS_ETRAFFIC_PARTNER_FEE("bus-etraffic-partner-fee", "etraffic-fee"),
    BUS_ETRAFFIC_YANDEX_FEE("bus-etraffic-yandex-fee", "etraffic-yandex-fee"),
    BUS_NOY_TICKET("bus-noy-ticket", "noy-ticket"),
    BUS_NOY_PARTNER_FEE("bus-noy-partner-fee", "noy-fee"),
    BUS_NOY_YANDEX_FEE("bus-noy-yandex-fee", "noy-yandex-fee"),
    BUS_OK_TICKET("bus-ok-ticket", "ok-ticket"),
    BUS_OK_PARTNER_FEE("bus-ok-partner-fee", "ok-fee"),
    BUS_OK_YANDEX_FEE("bus-ok-yandex-fee", "ok-yandex-fee"),
    BUS_RUSET_TICKET("bus-ruset-ticket", "ruset-ticket-v2"),
    BUS_RUSET_PARTNER_FEE("bus-ruset-partner-fee", "ruset-partner-fee-v2"),
    BUS_RUSET_YANDEX_FEE("bus-ruset-yandex-fee", "ruset-yandex-fee-v2"),
    BUS_SKS_TICKET("bus-sks-ticket", "sks-ticket-v2"),
    BUS_SKS_PARTNER_FEE("bus-sks-partner-fee", "sks-partner-fee-v2"),
    BUS_SKS_YANDEX_FEE("bus-sks-yandex-fee", "sks-yandex-fee-v2"),
    BUS_UNITIKI_NEW_TICKET("bus-unitiki-new-ticket", "unitiki-new-ticket-v2"),
    BUS_UNITIKI_NEW_PARTNER_FEE("bus-unitiki-new-partner-fee", "unitiki-new-partner-fee-v2"),
    BUS_UNITIKI_NEW_YANDEX_FEE("bus-unitiki-new-yandex-fee", "unitiki-new-yandex-fee-v2"),
    BUS_YUGAVTOTRANS_TICKET("bus-yugavtotrans-ticket", "yugavtotrans-ticket-v2"),
    BUS_YUGAVTOTRANS_PARTNER_FEE("bus-yugavtotrans-partner-fee", "yugavtotrans-partner-fee-v2"),
    BUS_YUGAVTOTRANS_YANDEX_FEE("bus-yugavtotrans-yandex-fee", "yugavtotrans-yandex-fee-v2"),

    HOTELS_YANDEX_PLUS_CASHBACK("hotels-yandex-plus-cashback", "HOTELS_PLUS_CASHBACK");

    public static final Set<FiscalItemType> YANDEX_FEES = Set.of(
            TRAIN_FEE,
            BUS_ATLASBUS_YANDEX_FEE,
            BUS_BUSFOR_YANDEX_FEE,
            BUS_ECOLINES_YANDEX_FEE,
            BUS_ETRAFFIC_YANDEX_FEE,
            BUS_NOY_YANDEX_FEE,
            BUS_OK_YANDEX_FEE,
            BUS_RUSET_YANDEX_FEE,
            BUS_SKS_YANDEX_FEE,
            BUS_UNITIKI_NEW_YANDEX_FEE,
            BUS_YUGAVTOTRANS_YANDEX_FEE
    );

    private final String value;
    private final String trustId;

    FiscalItemType(String value, String trustId) {
        this.value = value;
        this.trustId = trustId;
    }

    public String getValue() {
        return value;
    }

    public String getTrustId() {
        return this.trustId;
    }

    public Boolean isYandexFee() {
        return YANDEX_FEES.contains(this);
    }
}
