package ru.yandex.travel.orders.entities;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.proto.EFiscalReceiptType;

@RequiredArgsConstructor
public enum FiscalReceiptType {
    ACQUIRE("payment", EFiscalReceiptType.FRT_ACQUIRE),
    CLEAR("clear", EFiscalReceiptType.FRT_CLEAR),
    REFUND("refund", EFiscalReceiptType.FRT_REFUND);

    private final String value;
    private final EFiscalReceiptType protoValue;

    public String getValue() {
        return value;
    }

    public EFiscalReceiptType getProtoValue() {
        return protoValue;
    }
}
