package ru.yandex.travel.orders.entities;

import java.math.BigDecimal;

import lombok.Getter;

import ru.yandex.travel.commons.proto.ProtoCurrencyUnit;

public class FxContext {
    @Getter
    private ProtoCurrencyUnit baseCurrency;
    @Getter
    private FxRate fxRate;

    public FxContext(ProtoCurrencyUnit baseCurrency, FxRate fxRate) {
        this.baseCurrency = baseCurrency;
        this.fxRate = fxRate;
    }

    public FxContext(ProtoCurrencyUnit baseCurrency) {
        this.baseCurrency = baseCurrency;
        this.fxRate = null;
    }

    public BigDecimal getExchangeRateFor(ProtoCurrencyUnit fromCurrency, ProtoCurrencyUnit toCurrency) {
        if (fromCurrency.equals(toCurrency)) {
            return BigDecimal.valueOf(1L);
        } else if (fxRate != null && baseCurrency.equals(fromCurrency) && fxRate.getMap().containsKey(toCurrency.getProtoCurrency())) {
            return fxRate.get(toCurrency.getProtoCurrency());
        } else {
            throw new IllegalArgumentException(String.format("Unavailable exchange rate for %s -- %s", fromCurrency, toCurrency));
        }
    }

    public boolean isExchangePossible(ProtoCurrencyUnit fromCurrency, ProtoCurrencyUnit toCurrency) {
        return fromCurrency.equals(toCurrency) ||
                (fxRate != null && baseCurrency.equals(fromCurrency) && fxRate.getMap().containsKey(toCurrency.getProtoCurrency()));
    }
}
