package ru.yandex.travel.orders.entities;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import ru.yandex.travel.commons.proto.ECurrency;

@Data
public class FxRate {
    private Map<ECurrency, BigDecimal> fxRate;

    @JsonIgnore
    public Map<ECurrency, BigDecimal> getMap() {
        return fxRate;
    }

    public BigDecimal get(ECurrency currency) {
        return fxRate.get(currency);
    }

    public void putIfAbsent(ECurrency key, BigDecimal value) {
        if (fxRate == null) {
            fxRate = new HashMap<>();
        }
        fxRate.putIfAbsent(key, value);
    }

    public boolean contains(ECurrency key) {
        if (fxRate == null) {
            return false;
        }
        return fxRate.containsKey(key);
    }
}
