package ru.yandex.travel.orders.entities;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Type;

import ru.yandex.travel.orders.commons.proto.EOrderType;
import ru.yandex.travel.orders.workflow.order.generic.proto.EOrderState;
import ru.yandex.travel.workflow.entities.WorkflowEntity;


@Entity
@Getter
@Setter
@DiscriminatorValue(value = "generic_order")
public class GenericOrder extends Order implements WorkflowEntity<EOrderState> {
    @Type(type = "proto-enum")
    private EOrderState state;
    private Boolean paymentRetryEnabled;

    @Override
    public EOrderType getPublicType() {
        return EOrderType.OT_GENERIC;
    }

    @Override
    public String getEntityType() {
        return WellKnownWorkflowEntityType.GENERIC_ORDER.getDiscriminatorValue();
    }

    @Override
    public EOrderState getEntityState() {
        return state;
    }
}
