package ru.yandex.travel.orders.entities;

import java.util.Set;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Type;

import ru.yandex.travel.orders.commons.proto.EOrderType;
import ru.yandex.travel.orders.workflow.hotels.proto.EHotelOrderState;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

@Entity
@Getter
@Setter
@DiscriminatorValue(value = "hotel_order")
public class HotelOrder extends Order implements WorkflowEntity<EHotelOrderState> {
    @Getter(AccessLevel.NONE)
    private Boolean paymentRetryEnabled;

    @Type(type = "proto-enum")
    private EHotelOrderState state;

    @Override
    public EOrderType getPublicType() {
        return EOrderType.OT_HOTEL_EXPEDIA;
    }

    @Override
    public String getEntityType() {
        return WellKnownWorkflowEntityType.HOTEL_ORDER.getDiscriminatorValue();
    }

    @Override
    public EHotelOrderState getEntityState() {
        return state;
    }

    public boolean containsValidItems() {
        return getOrderItems().stream().allMatch(i -> i instanceof HotelOrderItem);
    }

    public boolean allHotelItemsAreIn(HotelOrderItem.HotelOrderItemState state) {
        return containsValidItems() && getOrderItems().stream().map(i -> (HotelOrderItem) i)
                .allMatch(i -> i.getPublicState() == state);
    }

    public boolean allHotelItemsAreIn(Set<HotelOrderItem.HotelOrderItemState> states) {
        return containsValidItems() && getOrderItems().stream().map(i -> (HotelOrderItem) i)
                .allMatch(i -> states.contains(i.getPublicState()));
    }

    public boolean atLeastOneHotelItemIsIn(HotelOrderItem.HotelOrderItemState state) {
        return containsValidItems() && getOrderItems().stream().map(i -> (HotelOrderItem) i)
                .anyMatch(i -> i.getPublicState() == state);
    }

    public boolean atLeastOneHotelItemIsIn(Set<HotelOrderItem.HotelOrderItemState> states) {
        return containsValidItems() && getOrderItems().stream().map(i -> (HotelOrderItem) i)
                .anyMatch(i -> states.contains(i.getPublicState()));
    }

    public boolean getPaymentRetryEnabled() {
        return paymentRetryEnabled != null && paymentRetryEnabled;
    }

    public EHotelOrderState getState() {
        return state;
    }
}
