package ru.yandex.travel.orders.entities;

import org.javamoney.moneta.Money;

import ru.yandex.travel.hotels.common.orders.HotelItinerary;
import ru.yandex.travel.hotels.proto.EPartnerId;

public abstract class HotelOrderItem extends OrderItem {
    public abstract HotelOrderItemState getPublicState();

    public abstract HotelItinerary getHotelItinerary();

    public abstract EPartnerId getPartnerId();

    @Override
    public Money preliminaryTotalCost() {
        return getHotelItinerary().getPriceAfterDiscount();
    }

    public enum HotelOrderItemState {
        NEW,
        RESERVED,
        CANCELLED,
        REFUNDED,
        CONFIRMED,
        OTHER
    }

    @Override
    public boolean isPostPaid() {
        return getHotelItinerary().getPostPay().applied();
    }

    @Override
    public boolean isPostPayEligible() {
        return getHotelItinerary().getPostPay().isEligible();
    }
}
