package ru.yandex.travel.orders.entities;

import java.util.Map;
import java.util.UUID;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.javamoney.moneta.Money;

import ru.yandex.travel.orders.workflow.hotels.proto.EHotelOrderState;

/**
 * Helper class. It is not an Entity (and thus is not a first-class DB citizen).
 * It gets serialized as json-b field with {@code MoneyRefund} and stores its mutable
 * data which is easier to store in non-normalized way for further extending
 */
@Data
public class MoneyRefundContext {
    private EHotelOrderState targetHotelOrderState;
    private Map<UUID, InvoiceRefund> invoicesToRefund;

    public enum InvoiceRefundState {
        PENDING,
        REFUNDED
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder(toBuilder = true)
    public static class InvoiceRefund {
        private UUID invoiceId;
        private InvoiceRefundState state;
        private Map<Long, Money> targetPricesByFiscalItem;
        private Map<Long, MoneyMarkup> targetPricesByFiscalItemMarkup;
    }
}
