package ru.yandex.travel.orders.entities;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import javax.money.CurrencyUnit;

import ru.yandex.bolts.collection.Tuple2;

public class MoneyTransferConfig {
    private final Map<Tuple2<UUID, UUID>, BigDecimal> transfers = new HashMap<>();

    private CurrencyUnit baseCurrency;
    private FxRate fxRate;

    private MoneyTransferConfig() {
    }

    public static MoneyTransferConfig create() {
        return new MoneyTransferConfig();
    }

    public MoneyTransferConfig addTransfer(UUID fromId, UUID toId, BigDecimal amount) {
        this.transfers.put(Tuple2.tuple(fromId, toId), amount);
        return this;
    }

    public Map<Tuple2<UUID, UUID>, BigDecimal> getTransfers() {
        return this.transfers;
    }

    public CurrencyUnit getBaseCurrency() {
        return this.baseCurrency;
    }

    public MoneyTransferConfig setBaseCurrency(CurrencyUnit currency) {
        this.baseCurrency = currency;
        return this;
    }

    public FxRate getFxRate() {
        return this.fxRate;
    }

    public MoneyTransferConfig setFxRate(FxRate fxRate) {
        this.fxRate = fxRate;
        return this;
    }

}
