package ru.yandex.travel.orders.entities;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import lombok.Getter;
import lombok.Setter;

@Entity
@Table(name = "notifier_state_changes")
@Getter
@Setter
public class NotifierStateChange {
    @Id
    @GeneratedValue(
            strategy = GenerationType.SEQUENCE,
            generator = "notifier_state_change_id_seq"
    )
    @SequenceGenerator(
            name = "notifier_state_change_id_seq",
            sequenceName = "notifier_state_change_id_seq",
            allocationSize = 1
    )
    private Long id;
    private UUID orderId;
    private Instant createdAt;

    public static NotifierStateChange createNotifierStateChange(UUID orderId) {
        NotifierStateChange change = new NotifierStateChange();
        change.setOrderId(orderId);
        change.setCreatedAt(Instant.now());
        return change;
    }
}
