package ru.yandex.travel.orders.entities;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.Data;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;

import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;
import ru.yandex.travel.orders.commons.proto.EOrderType;
import ru.yandex.travel.orders.proto.EGenericOrderAggregateState;
import ru.yandex.travel.orders.proto.EHotelOrderAggregateState;
import ru.yandex.travel.orders.proto.EPaymentErrorDisplayState;
import ru.yandex.travel.orders.proto.ETrainOrderAggregateErrorMessageCode;
import ru.yandex.travel.orders.proto.ETrainOrderAggregateErrorType;
import ru.yandex.travel.orders.proto.ETrainOrderAggregateState;
import ru.yandex.travel.orders.proto.ETrainOrderInsuranceAggregateState;

@Entity
@Table(name = "order_aggregate_states")
@Data
public class OrderAggregateState {
    @Id
    private UUID id;

    private String orderPrettyId;

    @Type(type = "proto-enum")
    private EDisplayOrderState orderDisplayState;

    private EOrderType orderType;

    private Instant reservedTo;

    @CreationTimestamp
    private Instant createdAt;
    @UpdateTimestamp
    private Instant updatedAt;

    @Version
    private Integer version;

    // common invoice fields

    @Type(type = "proto-enum")
    private EPaymentErrorDisplayState paymentErrorDisplayState;

    private String paymentUrl;

    // generic aggregate state fields

    @Type(type = "proto-enum")
    private EGenericOrderAggregateState genericOrderAggregateState;

    private String versionHash;

    // hotel aggregate state fields

    @Type(type = "proto-enum")
    private EHotelOrderAggregateState hotelOrderAggregateState;

    // train aggregate state fields

    private Instant maxPendingTill;

    @Type(type = "proto-enum")
    private ETrainOrderAggregateState trainOrderAggregateState;

    @Type(type = "proto-enum")
    private ETrainOrderInsuranceAggregateState trainOrderInsuranceAggregateState;

    private boolean hasTrainError;

    private String trainErrorMessage;

    private ETrainOrderAggregateErrorMessageCode trainErrorMessageCode;

    private ETrainOrderAggregateErrorType trainErrorType;

    @Type(type = "jsonb-object")
    private TrainOrderStateImErrorInfo trainImErrorInfo;
}
