package ru.yandex.travel.orders.entities;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.Type;

import ru.yandex.travel.orders.services.migrations.MigrationPayload;

@Entity
@Table(name = "order_item_migrations")
@Data
@EqualsAndHashCode
public class OrderItemMigration {
    @Id
    private UUID id;
    private boolean detailsMigrated;
    private Instant detailsMigratedAt;

    @Type(type = "jsonb-object")
    @Column(name = "payload")
    private MigrationPayload payload;
}
