package ru.yandex.travel.orders.entities;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Type;

@Entity
@Table(name = "order_label_params")
@Data
@EqualsAndHashCode
@ToString
@BatchSize(size = 100)
public class OrderLabelParams {
    @Id
    @GeneratedValue(
            strategy = GenerationType.SEQUENCE,
            generator = "order_label_params_id_seq"
    )
    @SequenceGenerator(
            name = "order_label_params_id_seq",
            sequenceName = "order_label_params_id_seq",
            allocationSize = 1
    )
    private Long id;

    @Type(type = "jsonb-node")
    private JsonNode payload;
}
